function [extin, chrome] = rbextinction(wavelen, type, varargin)
%
% [extin, chrome]=rbextinction(wavelen, type, interp1opt)
%
% Get the molar extinction coefficients for selected chromophores (columns)
% and wavelengths (rows)
%
% author: Qianqian Fang (q.fang <at> neu.edu)
%
% input:
%     wavelen: containing 1 or multiple wavelengths, as either string or
%         numbers
%     type: a string cell array, specifying the chromophore species, including
%          'hbo' - oxy-hemoglobin
%          'hbr' - deoxyhemoglobin
%          'water' - water (per volume fraction)
%          'lipids' - lipids (per volume fraction)
%          'aa3' - aa3
%     interp1opt: optional parameters to be used with interp1 for
%          interpolating at given wavelength values
%
% output:
%     extin: the extinction coeff as a matrix: rows: wavelengths; columns: chromorphores
%     chrome: full look-up table of the extincition coefficients
%
% These values for the molar extinction coefficient e in [cm-1/(moles/liter)]
% were compiled by Scott Prahl (scott.prahl@oit.edu) using data from
%
% https://omlc.org/spectra/hemoglobin/summary.html
%
% license:
%     GPL version 3, see LICENSE_GPLv3.txt files for details
%
% -- this function is part of Redbird-m toolbox
%

% lambda Hb02    Hb
% nm cm-1/M  cm-1/M

chrome.hb = [
             250 106112  112736
             252 105552  112736
             254 107660  112736
             256 109788  113824
             258 112944  115040
             260 116376  116296
             262 120188  117564
             264 124412  118876
             266 128696  120208
             268 133064  121544
             270 136068  122880
             272 137232  123096
             274 138408  121952
             276 137424  120808
             278 135820  119840
             280 131936  118872
             282 127720  117628
             284 122280  114820
             286 116508  112008
             288 108484  107140
             290 104752  98364
             292 98936   91636
             294 88136   85820
             296 79316   77100
             298 70884   69444
             300 65972   64440
             302 63208   61300
             304 61952   58828
             306 62352   56908
             308 62856   57620
             310 63352   59156
             312 65972   62248
             314 69016   65344
             316 72404   68312
             318 75536   71208
             320 78752   74508
             322 82256   78284
             324 85972   82060
             326 89796   85592
             328 93768   88516
             330 97512   90856
             332 100964  93192
             334 103504  95532
             336 104968  99792
             338 106452  104476
             340 107884  108472
             342 109060  110996
             344 110092  113524
             346 109032  116052
             348 107984  118752
             350 106576  122092
             352 105040  125436
             354 103696  128776
             356 101568  132120
             358 97828   133632
             360 94744   134940
             362 92248   136044
             364 89836   136972
             366 88484   137900
             368 87512   138856
             370 88176   139968
             372 91592   141084
             374 95140   142196
             376 98936   143312
             378 103432  144424
             380 109564  145232
             382 116968  145232
             384 125420  148668
             386 135132  153908
             388 148100  159544
             390 167748  167780
             392 189740  180004
             394 212060  191540
             396 231612  202124
             398 248404  212712
             400 266232  223296
             402 284224  236188
             404 308716  253368
             406 354208  270548
             408 422320  287356
             410 466840  303956
             412 500200  321344
             414 524280  342596
             416 521880  363848
             418 515520  385680
             420 480360  407560
             422 431880  429880
             424 376236  461200
             426 326032  481840
             428 283112  500840
             430 246072  528600
             432 214120  552160
             434 165332  552160
             436 132820  547040
             438 119140  501560
             440 102580  413280
             442 92780   363240
             444 81444   282724
             446 76324   237224
             448 67044   173320
             450 62816   103292
             452 58864   62640
             454 53552   36170
             456 49496   30698.8
             458 47496   25886.4
             460 44480   23388.8
             462 41320   20891.2
             464 39807.2 19260.8
             466 37073.2 18142.4
             468 34870.8 17025.6
             470 33209.2 16156.4
             472 31620   15310
             474 30113.6 15048.4
             476 28850.8 14792.8
             478 27718   14657.2
             480 26629.2 14550
             482 25701.6 14881.2
             484 25180.4 15212.4
             486 24669.6 15543.6
             488 24174.8 15898
             490 23684.4 16684
             492 23086.8 17469.6
             494 22457.6 18255.6
             496 21850.4 19041.2
             498 21260   19891.2
             500 20932.8 20862
             502 20596.4 21832.8
             504 20418   22803.6
             506 19946   23774.4
             508 19996   24745.2
             510 20035.2 25773.6
             512 20150.4 26936.8
             514 20429.2 28100
             516 21001.6 29263.2
             518 22509.6 30426.4
             520 24202.4 31589.6
             522 26450.4 32851.2
             524 29269.2 34397.6
             526 32496.4 35944
             528 35990   37490
             530 39956.8 39036.4
             532 43876   40584
             534 46924   42088
             536 49752   43592
             538 51712   45092
             540 53236   46592
             542 53292   48148
             544 52096   49708
             546 49868   51268
             548 46660   52496
             550 43016   53412
             552 39675.2 54080
             554 36815.2 54520
             556 34476.8 54540
             558 33456   54164
             560 32613.2 53788
             562 32620   52276
             564 33915.6 50572
             566 36495.2 48828
             568 40172   46948
             570 44496   45072
             572 49172   43340
             574 53308   41716
             576 55540   40092
             578 54728   38467.6
             580 50104   37020
             582 43304   35676.4
             584 34639.6 34332.8
             586 26600.4 32851.6
             588 19763.2 31075.2
             590 14400.8 28324.4
             592 10468.4 25470
             594 7678.8  22574.8
             596 5683.6  19800
             598 4504.4  17058.4
             600 3200    14677.2
             602 2664    13622.4
             604 2128    12567.6
             606 1789.2  11513.2
             608 1647.6  10477.6
             610 1506    9443.6
             612 1364.4  8591.2
             614 1222.8  7762
             616 1110    7344.8
             618 1026    6927.2
             620 942 6509.6
             622 858 6193.2
             624 774 5906.8
             626 707.6   5620
             628 658.8   5366.8
             630 610 5148.8
             632 561.2   4930.8
             634 512.4   4730.8
             636 478.8   4602.4
             638 460.4   4473.6
             640 442 4345.2
             642 423.6   4216.8
             644 405.2   4088.4
             646 390.4   3965.08
             648 379.2   3857.6
             650 368 3750.12
             652 356.8   3642.64
             654 345.6   3535.16
             656 335.2   3427.68
             658 325.6   3320.2
             660 319.6   3226.56
             662 314 3140.28
             664 308.4   3053.96
             666 302.8   2967.68
             668 298 2881.4
             670 294 2795.12
             672 290 2708.84
             674 285.6   2627.64
             676 282 2554.4
             678 279.2   2481.16
             680 277.6   2407.92
             682 276 2334.68
             684 274.4   2261.48
             686 272.8   2188.24
             688 274.4   2115
             690 276 2051.96
             692 277.6   2000.48
             694 279.2   1949.04
             696 282 1897.56
             698 286 1846.08
             700 290 1794.28
             702 294 1741
             704 298 1687.76
             706 302.8   1634.48
             708 308.4   1583.52
             710 314 1540.48
             712 319.6   1497.4
             714 325.2   1454.36
             716 332 1411.32
             718 340 1368.28
             720 348 1325.88
             722 356 1285.16
             724 364 1244.44
             726 372.4   1203.68
             728 381.2   1152.8
             730 390 1102.2
             732 398.8   1102.2
             734 407.6   1102.2
             736 418.8   1101.76
             738 432.4   1100.48
             740 446 1115.88
             742 459.6   1161.64
             744 473.2   1207.4
             746 487.6   1266.04
             748 502.8   1333.24
             750 518 1405.24
             752 533.2   1515.32
             754 548.4   1541.76
             756 562 1560.48
             758 574 1560.48
             760 586 1548.52
             762 598 1508.44
             764 610 1459.56
             766 622.8   1410.52
             768 636.4   1361.32
             770 650 1311.88
             772 663.6   1262.44
             774 677.2   1213
             776 689.2   1163.56
             778 699.6   1114.8
             780 710 1075.44
             782 720.4   1036.08
             784 730.8   996.72
             786 740 957.36
             788 748 921.8
             790 756 890.8
             792 764 859.8
             794 772 828.8
             796 786.4   802.96
             798 807.2   782.36
             800 816 761.72
             802 828 743.84
             804 836 737.08
             806 844 730.28
             808 856 723.52
             810 864 717.08
             812 872 711.84
             814 880 706.6
             816 887.2   701.32
             818 901.6   696.08
             820 916 693.76
             822 930.4   693.6
             824 944.8   693.48
             826 956.4   693.32
             828 965.2   693.2
             830 974 693.04
             832 982.8   692.92
             834 991.6   692.76
             836 1001.2  692.64
             838 1011.6  692.48
             840 1022    692.36
             842 1032.4  692.2
             844 1042.8  691.96
             846 1050    691.76
             848 1054    691.52
             850 1058    691.32
             852 1062    691.08
             854 1066    690.88
             856 1072.8  690.64
             858 1082.4  692.44
             860 1092    694.32
             862 1101.6  696.2
             864 1111.2  698.04
             866 1118.4  699.92
             868 1123.2  701.8
             870 1128    705.84
             872 1132.8  709.96
             874 1137.6  714.08
             876 1142.8  718.2
             878 1148.4  722.32
             880 1154    726.44
             882 1159.6  729.84
             884 1165.2  733.2
             886 1170    736.6
             888 1174    739.96
             890 1178    743.6
             892 1182    747.24
             894 1186    750.88
             896 1190    754.52
             898 1194    758.16
             900 1198    761.84
             902 1202    765.04
             904 1206    767.44
             906 1209.2  769.8
             908 1211.6  772.16
             910 1214    774.56
             912 1216.4  776.92
             914 1218.8  778.4
             916 1220.8  778.04
             918 1222.4  777.72
             920 1224    777.36
             922 1225.6  777.04
             924 1227.2  776.64
             926 1226.8  772.36
             928 1224.4  768.08
             930 1222    763.84
             932 1219.6  752.28
             934 1217.2  737.56
             936 1215.6  722.88
             938 1214.8  708.16
             940 1214    693.44
             942 1213.2  678.72
             944 1212.4  660.52
             946 1210.4  641.08
             948 1207.2  621.64
             950 1204    602.24
             952 1200.8  583.4
             954 1197.6  568.92
             956 1194    554.48
             958 1190    540.04
             960 1186    525.56
             962 1182    511.12
             964 1178    495.36
             966 1173.2  473.32
             968 1167.6  451.32
             970 1162    429.32
             972 1156.4  415.28
             974 1150.8  402.28
             976 1144    389.288
             978 1136    374.944
             980 1128    359.656
             982 1120    344.372
             984 1112    329.084
             986 1102.4  313.796
             988 1091.2  298.508
             990 1080    283.22
             992 1068.8  267.932
             994 1057.6  252.648
             996 1046.4  237.36
             998 1035.2  222.072
             1000    1024    206.784
            ];

chrome.water = [
                200.00  0.069000
                225.00  0.027400
                250.00  0.016800
                275.00  0.010700
                300.00  0.0067000
                325.00  0.0041800
                350.00  0.0023300
                375.00  0.0011700
                400.00  0.00058000
                425.00  0.00038000
                450.00  0.00028000
                475.00  0.00024700
                500.00  0.00025000
                525.00  0.00032000
                550.00  0.00045000
                575.00  0.00079000
                600.00  0.0023000
                625.00  0.0028000
                650.00  0.0032000
                675.00  0.0041500
                700.00  0.0060000
                725.00  0.015900
                750.00  0.026000
                775.00  0.024000
                800.00  0.020000
                810.00  0.019858
                820.00  0.023907
                825.00  0.028000
                830.00  0.029069
                840.00  0.034707
                850.00  0.043000
                860.00  0.046759
                870.00  0.051999
                875.00  0.056000
                880.00  0.055978
                890.00  0.060432
                900.00  0.068000
                910.00  0.072913
                920.00  0.10927
                925.00  0.14400
                930.00  0.17296
                940.00  0.26737
                950.00  0.39000
                960.00  0.42000
                970.00  0.45000
                975.00  0.45000
                980.00  0.43000
                990.00  0.41000
                1000.0  0.36000];

chrome.lipids = [
                 428.905 0.008288
                 429.552 0.008239
                 430.200 0.008206
                 430.847 0.008173
                 431.495 0.008114
                 432.142 0.008048
                 432.790 0.007948
                 433.438 0.007891
                 434.085 0.007822
                 434.733 0.007740
                 435.381 0.007675
                 436.028 0.007652
                 436.676 0.007644
                 437.324 0.007596
                 437.971 0.007563
                 438.619 0.007508
                 439.267 0.007471
                 439.915 0.007395
                 440.562 0.007308
                 441.210 0.007216
                 441.858 0.007119
                 442.506 0.007052
                 443.154 0.006974
                 443.801 0.006917
                 444.449 0.006855
                 445.097 0.006803
                 445.745 0.006747
                 446.393 0.006710
                 447.041 0.006656
                 447.689 0.006604
                 448.337 0.006538
                 448.984 0.006466
                 449.632 0.006406
                 450.280 0.006331
                 450.928 0.006298
                 451.576 0.006242
                 452.224 0.006199
                 452.872 0.006145
                 453.520 0.006096
                 454.168 0.006051
                 454.816 0.005971
                 455.464 0.005905
                 456.112 0.005828
                 456.761 0.005772
                 457.409 0.005719
                 458.057 0.005660
                 458.705 0.005615
                 459.353 0.005565
                 460.001 0.005523
                 460.649 0.005458
                 461.297 0.005370
                 461.946 0.005295
                 462.594 0.005210
                 463.242 0.005117
                 463.890 0.005003
                 464.538 0.004905
                 465.187 0.004826
                 465.835 0.004740
                 466.483 0.004656
                 467.131 0.004584
                 467.780 0.004531
                 468.428 0.004481
                 469.076 0.004427
                 469.725 0.004360
                 470.373 0.004289
                 471.021 0.004206
                 471.670 0.004125
                 472.318 0.004049
                 472.967 0.003965
                 473.615 0.003887
                 474.263 0.003805
                 474.912 0.003741
                 475.560 0.003681
                 476.209 0.003620
                 476.857 0.003548
                 477.506 0.003486
                 478.154 0.003443
                 478.803 0.003400
                 479.451 0.003358
                 480.100 0.003310
                 480.748 0.003279
                 481.397 0.003239
                 482.045 0.003189
                 482.694 0.003139
                 483.343 0.003077
                 483.991 0.003014
                 484.640 0.002951
                 485.288 0.002891
                 485.937 0.002837
                 486.586 0.002781
                 487.234 0.002730
                 487.883 0.002685
                 488.532 0.002636
                 489.180 0.002588
                 489.829 0.002528
                 490.478 0.002475
                 491.127 0.002429
                 491.775 0.002384
                 492.424 0.002341
                 493.073 0.002295
                 493.722 0.002266
                 494.371 0.002234
                 495.019 0.002192
                 495.668 0.002146
                 496.317 0.002098
                 496.966 0.002063
                 497.615 0.002021
                 498.264 0.001981
                 498.913 0.001946
                 499.561 0.001919
                 500.210 0.001904
                 500.859 0.001881
                 501.508 0.001855
                 502.157 0.001821
                 502.806 0.001786
                 503.455 0.001755
                 504.104 0.001720
                 504.753 0.001691
                 505.402 0.001664
                 506.051 0.001648
                 506.700 0.001634
                 507.349 0.001609
                 507.998 0.001577
                 508.647 0.001547
                 509.297 0.001522
                 509.946 0.001503
                 510.595 0.001482
                 511.244 0.001467
                 511.893 0.001460
                 512.542 0.001445
                 513.191 0.001432
                 513.841 0.001409
                 514.490 0.001386
                 515.139 0.001363
                 515.788 0.001337
                 516.437 0.001318
                 517.087 0.001296
                 517.736 0.001277
                 518.385 0.001260
                 519.035 0.001246
                 519.684 0.001238
                 520.333 0.001225
                 520.982 0.001212
                 521.632 0.001199
                 522.281 0.001183
                 522.931 0.001168
                 523.580 0.001151
                 524.229 0.001142
                 524.879 0.001135
                 525.528 0.001124
                 526.177 0.001111
                 526.827 0.001096
                 527.476 0.001080
                 528.126 0.001061
                 528.775 0.001045
                 529.425 0.001036
                 530.074 0.001030
                 530.724 0.001022
                 531.373 0.001010
                 532.023 0.001002
                 532.672 0.000994
                 533.322 0.000989
                 533.972 0.000985
                 534.621 0.000981
                 535.271 0.000980
                 535.920 0.000972
                 536.570 0.000961
                 537.220 0.000945
                 537.869 0.000931
                 538.519 0.000922
                 539.169 0.000910
                 539.818 0.000899
                 540.468 0.000888
                 541.118 0.000879
                 541.767 0.000868
                 542.417 0.000857
                 543.067 0.000849
                 543.717 0.000843
                 544.366 0.000838
                 545.016 0.000833
                 545.666 0.000830
                 546.316 0.000828
                 546.966 0.000823
                 547.616 0.000814
                 548.265 0.000799
                 548.915 0.000787
                 549.565 0.000778
                 550.215 0.000770
                 550.865 0.000764
                 551.515 0.000761
                 552.165 0.000760
                 552.815 0.000760
                 553.465 0.000754
                 554.115 0.000745
                 554.765 0.000735
                 555.415 0.000728
                 556.065 0.000725
                 556.715 0.000721
                 557.365 0.000716
                 558.015 0.000710
                 558.665 0.000706
                 559.315 0.000702
                 559.965 0.000698
                 560.615 0.000693
                 561.265 0.000688
                 561.915 0.000683
                 562.565 0.000678
                 563.215 0.000672
                 563.866 0.000664
                 564.516 0.000657
                 565.166 0.000651
                 565.816 0.000649
                 566.466 0.000645
                 567.116 0.000641
                 567.767 0.000637
                 568.417 0.000633
                 569.067 0.000630
                 569.717 0.000628
                 570.368 0.000631
                 571.018 0.000634
                 572.319 0.000637
                 572.969 0.000633
                 573.619 0.000623
                 574.270 0.000608
                 574.920 0.000592
                 575.570 0.000578
                 576.221 0.000567
                 576.871 0.000563
                 577.522 0.000562
                 578.172 0.000566
                 578.823 0.000567
                 579.473 0.000569
                 580.123 0.000566
                 580.774 0.000564
                 581.424 0.000564
                 582.075 0.000563
                 582.725 0.000564
                 583.376 0.000561
                 584.026 0.000557
                 584.677 0.000550
                 585.328 0.000545
                 585.978 0.000542
                 586.629 0.000535
                 587.279 0.000527
                 587.930 0.000521
                 588.581 0.000517
                 589.231 0.000513
                 589.882 0.000504
                 590.533 0.000496
                 591.183 0.000491
                 591.834 0.000488
                 592.485 0.000488
                 593.135 0.000486
                 593.786 0.000486
                 594.437 0.000485
                 595.088 0.000487
                 595.738 0.000482
                 596.389 0.000477
                 597.040 0.000472
                 597.691 0.000469
                 598.342 0.000468
                 598.992 0.000463
                 599.643 0.000464
                 600.294 0.000466
                 600.945 0.000471
                 601.596 0.000476
                 602.247 0.000480
                 602.898 0.000487
                 603.549 0.000489
                 604.200 0.000489
                 604.850 0.000485
                 605.501 0.000483
                 606.152 0.000481
                 606.803 0.000477
                 607.454 0.000473
                 608.105 0.000470
                 608.756 0.000470
                 609.407 0.000467
                 610.058 0.000464
                 610.710 0.000459
                 611.361 0.000458
                 612.012 0.000454
                 612.663 0.000448
                 613.314 0.000439
                 613.965 0.000428
                 614.616 0.000422
                 615.267 0.000419
                 615.918 0.000423
                 616.570 0.000428
                 617.221 0.000433
                 617.872 0.000437
                 618.523 0.000439
                 619.174 0.000436
                 619.826 0.000431
                 620.477 0.000427
                 621.128 0.000427
                 621.779 0.000432
                 622.431 0.000437
                 623.082 0.000441
                 623.733 0.000440
                 624.385 0.000437
                 625.036 0.000432
                 625.687 0.000427
                 626.339 0.000425
                 626.990 0.000425
                 627.641 0.000425
                 628.293 0.000427
                 628.944 0.000429
                 629.596 0.000429
                 630.247 0.000428
                 630.899 0.000429
                 631.550 0.000434
                 632.201 0.000440
                 632.853 0.000444
                 633.504 0.000445
                 634.156 0.000442
                 634.807 0.000434
                 635.459 0.000425
                 636.111 0.000421
                 636.762 0.000420
                 637.414 0.000426
                 638.065 0.000435
                 638.717 0.000445
                 639.368 0.000450
                 640.020 0.000452
                 640.672 0.000451
                 641.323 0.000451
                 641.975 0.000450
                 642.627 0.000450
                 643.278 0.000455
                 643.930 0.000460
                 644.582 0.000466
                 645.234 0.000466
                 645.885 0.000464
                 646.537 0.000464
                 647.189 0.000464
                 647.841 0.000465
                 648.492 0.000464
                 649.144 0.000467
                 649.796 0.000471
                 650.448 0.000472
                 651.100 0.000472
                 651.751 0.000468
                 652.403 0.000466
                 653.055 0.000464
                 653.707 0.000461
                 654.359 0.000455
                 655.011 0.000448
                 655.663 0.000442
                 656.315 0.000435
                 656.967 0.000429
                 657.619 0.000425
                 658.271 0.000424
                 658.923 0.000422
                 659.575 0.000420
                 660.227 0.000418
                 660.879 0.000414
                 661.531 0.000413
                 662.183 0.000412
                 662.835 0.000414
                 663.487 0.000417
                 664.139 0.000420
                 664.791 0.000426
                 665.443 0.000432
                 666.095 0.000441
                 666.747 0.000446
                 667.400 0.000451
                 668.052 0.000452
                 668.704 0.000454
                 669.356 0.000452
                 670.008 0.000451
                 670.661 0.000451
                 671.313 0.000453
                 671.965 0.000458
                 672.617 0.000462
                 673.270 0.000464
                 673.922 0.000464
                 674.574 0.000462
                 675.226 0.000457
                 675.879 0.000449
                 676.531 0.000438
                 677.183 0.000430
                 677.836 0.000424
                 678.488 0.000419
                 679.140 0.000413
                 679.793 0.000409
                 680.445 0.000405
                 681.098 0.000398
                 681.750 0.000390
                 682.403 0.000380
                 683.055 0.000375
                 683.707 0.000371
                 684.360 0.000370
                 685.012 0.000369
                 685.665 0.000368
                 686.317 0.000365
                 686.970 0.000362
                 687.623 0.000357
                 688.275 0.000352
                 688.928 0.000349
                 689.580 0.000344
                 690.233 0.000342
                 690.885 0.000339
                 691.538 0.000338
                 692.191 0.000335
                 692.843 0.000332
                 693.496 0.000329
                 694.149 0.000328
                 694.801 0.000325
                 695.454 0.000323
                 696.107 0.000322
                 696.759 0.000324
                 697.412 0.000326
                 698.065 0.000327
                 698.718 0.000327
                 699.370 0.000324
                 700.023 0.000323
                 700.676 0.000321
                 701.329 0.000319
                 701.982 0.000319
                 702.634 0.000321
                 703.287 0.000324
                 703.940 0.000326
                 704.593 0.000325
                 705.246 0.000323
                 705.899 0.000320
                 706.552 0.000316
                 707.205 0.000313
                 707.858 0.000310
                 708.510 0.000310
                 709.163 0.000312
                 709.816 0.000315
                 710.469 0.000319
                 711.122 0.000321
                 711.775 0.000322
                 712.428 0.000322
                 713.081 0.000320
                 713.734 0.000320
                 714.388 0.000321
                 715.041 0.000327
                 715.694 0.000332
                 716.347 0.000337
                 717.000 0.000344
                 717.653 0.000349
                 718.306 0.000354
                 718.959 0.000358
                 719.612 0.000364
                 720.266 0.000369
                 720.919 0.000376
                 721.572 0.000381
                 722.225 0.000385
                 722.878 0.000390
                 723.532 0.000395
                 724.185 0.000404
                 724.838 0.000413
                 725.491 0.000422
                 726.145 0.000433
                 726.798 0.000444
                 727.451 0.000455
                 728.105 0.000465
                 728.758 0.000476
                 729.411 0.000489
                 730.065 0.000500
                 730.718 0.000512
                 731.371 0.000522
                 732.025 0.000536
                 732.678 0.000548
                 733.332 0.000556
                 733.985 0.000564
                 734.638 0.000572
                 735.292 0.000581
                 735.945 0.000589
                 736.599 0.000595
                 737.252 0.000604
                 737.906 0.000615
                 738.559 0.000628
                 739.213 0.000640
                 739.867 0.000651
                 740.520 0.000668
                 741.174 0.000683
                 741.827 0.000702
                 742.481 0.000720
                 743.134 0.000740
                 743.788 0.000761
                 744.442 0.000782
                 745.095 0.000805
                 745.749 0.000828
                 746.403 0.000853
                 747.056 0.000877
                 747.710 0.000899
                 748.364 0.000921
                 749.017 0.000942
                 749.671 0.000963
                 750.325 0.000983
                 750.979 0.001001
                 751.632 0.001019
                 752.286 0.001039
                 752.940 0.001058
                 753.594 0.001077
                 754.248 0.001096
                 754.902 0.001117
                 755.555 0.001140
                 756.209 0.001163
                 756.863 0.001186
                 757.517 0.001211
                 758.171 0.001235
                 758.825 0.001255
                 759.479 0.001269
                 760.133 0.001281
                 760.787 0.001289
                 761.441 0.001291
                 762.095 0.001289
                 762.749 0.001280
                 763.403 0.001267
                 764.057 0.001247
                 764.711 0.001222
                 765.365 0.001190
                 766.019 0.001152
                 766.673 0.001112
                 767.327 0.001069
                 767.981 0.001023
                 768.635 0.000976
                 769.289 0.000927
                 769.943 0.000876
                 770.597 0.000824
                 771.252 0.000774
                 771.906 0.000726
                 772.560 0.000680
                 773.214 0.000638
                 773.868 0.000602
                 774.522 0.000572
                 775.177 0.000545
                 775.831 0.000521
                 776.485 0.000498
                 777.139 0.000477
                 777.794 0.000457
                 778.448 0.000440
                 779.102 0.000425
                 779.757 0.000414
                 780.411 0.000402
                 781.065 0.000391
                 781.720 0.000382
                 782.374 0.000374
                 783.028 0.000366
                 783.683 0.000361
                 784.337 0.000358
                 784.992 0.000357
                 785.646 0.000356
                 786.300 0.000355
                 786.955 0.000354
                 787.609 0.000350
                 788.264 0.000349
                 788.918 0.000346
                 789.573 0.000347
                 790.227 0.000345
                 790.882 0.000347
                 791.536 0.000347
                 792.191 0.000347
                 792.846 0.000347
                 793.500 0.000349
                 794.155 0.000353
                 794.809 0.000358
                 795.464 0.000364
                 796.119 0.000370
                 796.773 0.000377
                 797.428 0.000383
                 798.082 0.000388
                 798.737 0.000391
                 799.392 0.000396
                 800.047 0.000404
                 800.701 0.000411
                 801.356 0.000417
                 802.011 0.000424
                 802.665 0.000432
                 803.320 0.000438
                 803.975 0.000443
                 804.630 0.000449
                 805.285 0.000458
                 805.939 0.000467
                 806.594 0.000476
                 807.249 0.000486
                 807.904 0.000496
                 808.559 0.000505
                 809.214 0.000514
                 809.869 0.000525
                 810.523 0.000538
                 811.178 0.000552
                 811.833 0.000565
                 812.488 0.000576
                 813.143 0.000585
                 813.798 0.000592
                 814.453 0.000597
                 815.108 0.000604
                 815.763 0.000611
                 816.418 0.000622
                 817.073 0.000635
                 817.728 0.000649
                 818.383 0.000665
                 819.038 0.000675
                 819.693 0.000687
                 820.349 0.000698
                 821.004 0.000709
                 821.659 0.000720
                 822.314 0.000727
                 822.969 0.000740
                 823.624 0.000753
                 824.279 0.000764
                 824.935 0.000774
                 825.590 0.000782
                 826.245 0.000792
                 826.900 0.000796
                 827.555 0.000798
                 828.211 0.000800
                 828.866 0.000802
                 829.521 0.000804
                 830.176 0.000803
                 830.832 0.000803
                 831.487 0.000803
                 832.142 0.000801
                 832.798 0.000796
                 833.453 0.000791
                 834.108 0.000784
                 834.764 0.000778
                 835.419 0.000771
                 836.075 0.000764
                 836.730 0.000759
                 837.385 0.000755
                 838.041 0.000751
                 838.696 0.000743
                 839.352 0.000735
                 840.007 0.000727
                 840.663 0.000720
                 841.318 0.000711
                 841.974 0.000704
                 842.629 0.000695
                 843.285 0.000689
                 843.940 0.000686
                 844.596 0.000682
                 845.251 0.000676
                 845.907 0.000670
                 846.563 0.000666
                 847.218 0.000661
                 847.874 0.000653
                 848.529 0.000646
                 849.185 0.000642
                 849.841 0.000638
                 850.496 0.000637
                 851.152 0.000633
                 851.808 0.000633
                 852.463 0.000631
                 853.119 0.000632
                 853.775 0.000632
                 854.431 0.000635
                 855.086 0.000640
                 855.742 0.000646
                 856.398 0.000652
                 857.054 0.000656
                 857.710 0.000662
                 858.365 0.000664
                 859.021 0.000666
                 859.677 0.000672
                 860.333 0.000676
                 860.989 0.000680
                 861.645 0.000686
                 862.301 0.000694
                 862.957 0.000705
                 863.612 0.000714
                 864.268 0.000729
                 864.924 0.000748
                 865.580 0.000772
                 866.236 0.000794
                 866.892 0.000818
                 867.548 0.000843
                 868.204 0.000870
                 868.860 0.000894
                 869.516 0.000918
                 870.172 0.000945
                 870.828 0.000972
                 871.485 0.001003
                 872.141 0.001029
                 872.797 0.001062
                 873.453 0.001099
                 874.109 0.001141
                 874.765 0.001182
                 875.421 0.001223
                 876.077 0.001271
                 876.734 0.001322
                 877.390 0.001378
                 878.046 0.001435
                 878.702 0.001495
                 879.358 0.001565
                 880.015 0.001638
                 880.671 0.001714
                 881.327 0.001789
                 881.983 0.001866
                 882.640 0.001946
                 883.296 0.002028
                 883.952 0.002115
                 884.609 0.002204
                 885.265 0.002299
                 885.921 0.002401
                 886.578 0.002509
                 887.234 0.002622
                 887.890 0.002735
                 888.547 0.002850
                 889.203 0.002968
                 889.860 0.003090
                 890.516 0.003214
                 891.173 0.003337
                 891.829 0.003461
                 892.485 0.003582
                 893.142 0.003697
                 893.798 0.003803
                 894.455 0.003903
                 895.112 0.003999
                 895.768 0.004091
                 896.425 0.004180
                 897.081 0.004267
                 897.738 0.004352
                 898.394 0.004435
                 899.051 0.004513
                 899.708 0.004595
                 900.364 0.004680
                 901.021 0.004770
                 901.677 0.004863
                 902.334 0.004965
                 902.991 0.005077
                 903.647 0.005196
                 904.304 0.005322
                 904.961 0.005464
                 905.618 0.005619
                 906.274 0.005790
                 906.931 0.005974
                 907.588 0.006175
                 908.245 0.006393
                 908.901 0.006626
                 909.558 0.006873
                 910.215 0.007127
                 910.872 0.007388
                 911.529 0.007649
                 912.186 0.007913
                 912.842 0.008174
                 913.499 0.008430
                 914.156 0.008681
                 914.813 0.008928
                 915.470 0.009167
                 916.127 0.009396
                 916.784 0.009614
                 917.441 0.009827
                 918.098 0.010036
                 918.755 0.010248
                 919.412 0.010462
                 920.069 0.010682
                 920.726 0.010903
                 921.383 0.011127
                 922.040 0.011352
                 922.697 0.011576
                 923.354 0.011795
                 924.011 0.012009
                 924.668 0.012220
                 925.325 0.012419
                 925.982 0.012601
                 926.640 0.012756
                 927.297 0.012890
                 927.954 0.012993
                 928.611 0.013067
                 929.268 0.013105
                 929.925 0.013105
                 930.583 0.013064
                 931.240 0.012982
                 931.897 0.012858
                 932.554 0.012688
                 933.212 0.012479
                 933.869 0.012239
                 934.526 0.011976
                 935.183 0.011679
                 935.841 0.011350
                 936.498 0.010989
                 937.155 0.010611
                 937.813 0.010210
                 938.470 0.009788
                 939.127 0.009346
                 939.785 0.008897
                 940.442 0.008459
                 941.100 0.008023
                 941.757 0.007598
                 942.414 0.007180
                 943.072 0.006780
                 943.729 0.006397
                 944.387 0.006031
                 945.044 0.005683
                 945.702 0.005363
                 946.359 0.005062
                 947.017 0.004796
                 947.674 0.004556
                 948.332 0.004332
                 948.989 0.004113
                 949.647 0.003899
                 950.305 0.003709
                 950.962 0.003529
                 951.620 0.003362
                 952.277 0.003203
                 952.935 0.003060
                 953.593 0.002929
                 954.250 0.002803
                 954.908 0.002682
                 955.566 0.002569
                 956.223 0.002464
                 956.881 0.002373
                 957.539 0.002293
                 958.196 0.002218
                 958.854 0.002148
                 959.512 0.002083
                 960.170 0.002031
                 960.828 0.001986
                 961.485 0.001943
                 962.143 0.001909
                 962.801 0.001871
                 963.459 0.001840
                 964.117 0.001802
                 964.775 0.001767
                 965.432 0.001726
                 966.090 0.001688
                 966.748 0.001652
                 967.406 0.001619
                 968.064 0.001587
                 968.722 0.001562
                 969.380 0.001544
                 970.038 0.001528
                 970.696 0.001516
                 971.354 0.001501
                 972.012 0.001491
                 972.670 0.001474
                 973.328 0.001454
                 973.986 0.001432
                 974.644 0.001416
                 975.302 0.001410
                 975.960 0.001409
                 976.618 0.001412
                 977.276 0.001415
                 977.934 0.001421
                 978.592 0.001426
                 979.251 0.001426
                 979.909 0.001419
                 980.567 0.001408
                 981.225 0.001403
                 981.883 0.001405
                 982.541 0.001412
                 983.200 0.001419
                 983.858 0.001436
                 984.516 0.001460
                 985.174 0.001491
                 985.833 0.001518
                 986.491 0.001543
                 987.149 0.001571
                 987.807 0.001598
                 988.466 0.001628
                 989.124 0.001660
                 989.782 0.001700
                 990.441 0.001749
                 991.099 0.001803
                 991.758 0.001867
                 992.416 0.001933
                 993.074 0.002001
                 993.733 0.002063
                 994.391 0.002121
                 995.050 0.002183
                 995.708 0.002245
                 996.366 0.002307
                 997.025 0.002369
                 997.683 0.002434
                 998.342 0.002499
                 999.000 0.002560
                 999.659 0.002621
                 1000.320    0.002684
                 1000.980    0.002750
                 1001.630    0.002824
                 1002.290    0.002903
                 1002.950    0.002990
                 1003.610    0.003079
                 1004.270    0.003174
                 1004.930    0.003273
                 1005.590    0.003369
                 1006.240    0.003465
                 1006.900    0.003564
                 1007.560    0.003665
                 1008.220    0.003771
                 1008.880    0.003875
                 1009.540    0.003982
                 1010.200    0.004091
                 1010.860    0.004199
                 1011.510    0.004307
                 1012.170    0.004415
                 1012.830    0.004527
                 1013.490    0.004638
                 1014.150    0.004746
                 1014.810    0.004850
                 1015.470    0.004950
                 1016.130    0.005041
                 1016.790    0.005126
                 1017.440    0.005207
                 1018.100    0.005291
                 1018.760    0.005364
                 1019.420    0.005429
                 1020.080    0.005488
                 1020.740    0.005544
                 1021.400    0.005596
                 1022.060    0.005634
                 1022.720    0.005670
                 1023.370    0.005704
                 1024.030    0.005736
                 1024.690    0.005770
                 1025.350    0.005808
                 1026.010    0.005858
                 1026.670    0.005916
                 1027.330    0.005975
                 1027.990    0.006049
                 1028.650    0.006126
                 1029.310    0.006200
                 1029.960    0.006270
                 1030.620    0.006346
                 1031.280    0.006426
                 1031.940    0.006497
                 1032.600    0.006567
                 1033.260    0.006637
                 1033.920    0.006711
                 1034.580    0.006768
                 1035.240    0.006822
                 1035.900    0.006865
                 1036.560    0.006906
                 1037.220    0.006943
                 1037.870    0.006965
                 1038.530    0.006991
                 1039.190    0.007008
                 1039.850    0.007030
                 1040.510    0.007027
                 1041.170    0.007019
                 1041.830    0.007005
                 1042.490    0.006986
                 1043.150    0.006958
                 1043.810    0.006914
                 1044.470    0.006879
                 1045.130    0.006843
                 1045.790    0.006807
                 1046.450    0.006764
                 1047.110    0.006714
                 1047.770    0.006678
                 1048.420    0.006637
                 1049.080    0.006589
                 1049.740    0.006526
                 1050.400    0.006466
                 1051.060    0.006415
                 1051.720    0.006368
                 1052.380    0.006324
                 1053.040    0.006279
                 1053.700    0.006235
                 1054.360    0.006189
                 1055.020    0.006137
                 1055.680    0.006077
                 1056.340    0.006010
                 1057.000    0.005949
                 1057.660    0.005894
                 1058.320    0.005841
                 1058.980    0.005791
                 1059.640    0.005737
                 1060.300    0.005682
                 1060.960    0.005619
                 1061.620    0.005568
                 1062.280    0.005505
                 1062.940    0.005451
                 1063.600    0.005389
                 1064.260    0.005350
                 1064.920    0.005307
                 1065.570    0.005274
                 1066.230    0.005252
                 1066.890    0.005228
                 1067.550    0.005207
                 1068.210    0.005166
                 1068.870    0.005131
                 1069.530    0.005083
                 1070.190    0.005051
                 1070.850    0.005033
                 1071.510    0.005029
                 1072.170    0.005025
                 1072.830    0.005018
                 1073.490    0.005011
                 1074.150    0.004997
                 1074.810    0.004960
                 1075.470    0.004914
                 1076.130    0.004874
                 1076.790    0.004854
                 1077.450    0.004849
                 1078.110    0.004838
                 1078.770    0.004818
                 1079.430    0.004811
                 1080.090    0.004812
                 1080.750    0.004816
                 1081.410    0.004811
                 1082.070    0.004801
                 1082.730    0.004821
                 1083.390    0.004816
                 1084.050    0.004802
                 1084.710    0.004766
                 1085.370    0.004752
                 1086.030    0.004755
                 1086.690    0.004760
                 1087.350    0.004762
                 1088.010    0.004772
                 1088.680    0.004797
                 1089.340    0.004805
                 1090.000    0.004802
                 1090.660    0.004780
                 1091.320    0.004788
                 1091.980    0.004783
                 1092.640    0.004781
                 1093.300    0.004785
                 1093.960    0.004789
                 1094.620    0.004822
                 1095.280    0.004844
                 1095.940    0.004876
                 1096.600    0.004885
                 1097.260    0.004888
                 1097.920    0.004909];

chrome.aa3 = [
              6.5000000e+002  1.1361272e+000
              6.5050000e+002  1.1318779e+000
              6.5100000e+002  1.1276285e+000
              6.5150000e+002  1.1233792e+000
              6.5200000e+002  1.1191298e+000
              6.5250000e+002  1.1135125e+000
              6.5300000e+002  1.1078952e+000
              6.5350000e+002  1.1022779e+000
              6.5400000e+002  1.0966605e+000
              6.5450000e+002  1.0903251e+000
              6.5500000e+002  1.0839896e+000
              6.5550000e+002  1.0776542e+000
              6.5600000e+002  1.0713187e+000
              6.5650000e+002  1.0643820e+000
              6.5700000e+002  1.0574453e+000
              6.5750000e+002  1.0505086e+000
              6.5800000e+002  1.0435719e+000
              6.5850000e+002  1.0362062e+000
              6.5900000e+002  1.0288404e+000
              6.5950000e+002  1.0214747e+000
              6.6000000e+002  1.0141090e+000
              6.6050000e+002  1.0062588e+000
              6.6100000e+002  9.9840857e-001
              6.6150000e+002  9.9055837e-001
              6.6200000e+002  9.8270816e-001
              6.6250000e+002  9.7439221e-001
              6.6300000e+002  9.6607626e-001
              6.6350000e+002  9.5776031e-001
              6.6400000e+002  9.4944435e-001
              6.6450000e+002  9.4080158e-001
              6.6500000e+002  9.3215880e-001
              6.6550000e+002  9.2351603e-001
              6.6600000e+002  9.1487325e-001
              6.6650000e+002  9.0655165e-001
              6.6700000e+002  8.9823004e-001
              6.6750000e+002  8.8990843e-001
              6.6800000e+002  8.8158682e-001
              6.6850000e+002  8.7315553e-001
              6.6900000e+002  8.6472424e-001
              6.6950000e+002  8.5629295e-001
              6.7000000e+002  8.4786166e-001
              6.7050000e+002  8.3951725e-001
              6.7100000e+002  8.3117284e-001
              6.7150000e+002  8.2282843e-001
              6.7200000e+002  8.1448402e-001
              6.7250000e+002  8.0625998e-001
              6.7300000e+002  7.9803594e-001
              6.7350000e+002  7.8981191e-001
              6.7400000e+002  7.8158787e-001
              6.7450000e+002  7.7355802e-001
              6.7500000e+002  7.6552817e-001
              6.7550000e+002  7.5749832e-001
              6.7600000e+002  7.4946847e-001
              6.7650000e+002  7.4157127e-001
              6.7700000e+002  7.3367407e-001
              6.7750000e+002  7.2577687e-001
              6.7800000e+002  7.1787968e-001
              6.7850000e+002  7.1103726e-001
              6.7900000e+002  7.0419484e-001
              6.7950000e+002  6.9735242e-001
              6.8000000e+002  6.9051001e-001
              6.8050000e+002  6.8506908e-001
              6.8100000e+002  6.7962815e-001
              6.8150000e+002  6.7418722e-001
              6.8200000e+002  6.6874629e-001
              6.8250000e+002  6.6413673e-001
              6.8300000e+002  6.5952716e-001
              6.8350000e+002  6.5491759e-001
              6.8400000e+002  6.5030802e-001
              6.8450000e+002  6.4610502e-001
              6.8500000e+002  6.4190202e-001
              6.8550000e+002  6.3769903e-001
              6.8600000e+002  6.3349603e-001
              6.8650000e+002  6.2987997e-001
              6.8700000e+002  6.2626392e-001
              6.8750000e+002  6.2264786e-001
              6.8800000e+002  6.1903181e-001
              6.8850000e+002  6.1593488e-001
              6.8900000e+002  6.1283796e-001
              6.8950000e+002  6.0974103e-001
              6.9000000e+002  6.0664411e-001
              6.9050000e+002  6.0393052e-001
              6.9100000e+002  6.0121692e-001
              6.9150000e+002  5.9850333e-001
              6.9200000e+002  5.9578974e-001
              6.9250000e+002  5.9354479e-001
              6.9300000e+002  5.9129984e-001
              6.9350000e+002  5.8905489e-001
              6.9400000e+002  5.8680994e-001
              6.9450000e+002  5.8419281e-001
              6.9500000e+002  5.8157569e-001
              6.9550000e+002  5.7895857e-001
              6.9600000e+002  5.7634144e-001
              6.9650000e+002  5.7395588e-001
              6.9700000e+002  5.7157032e-001
              6.9750000e+002  5.6918475e-001
              6.9800000e+002  5.6679919e-001
              6.9850000e+002  5.6423313e-001
              6.9900000e+002  5.6166706e-001
              6.9950000e+002  5.5910100e-001
              7.0000000e+002  5.5653494e-001
              7.0050000e+002  5.5386633e-001
              7.0100000e+002  5.5119773e-001
              7.0150000e+002  5.4852912e-001
              7.0200000e+002  5.4586052e-001
              7.0250000e+002  5.4295036e-001
              7.0300000e+002  5.4004020e-001
              7.0350000e+002  5.3713004e-001
              7.0400000e+002  5.3421989e-001
              7.0450000e+002  5.3157177e-001
              7.0500000e+002  5.2892366e-001
              7.0550000e+002  5.2627555e-001
              7.0600000e+002  5.2362744e-001
              7.0650000e+002  5.2040945e-001
              7.0700000e+002  5.1719147e-001
              7.0750000e+002  5.1397349e-001
              7.0800000e+002  5.1075551e-001
              7.0850000e+002  5.0755727e-001
              7.0900000e+002  5.0435903e-001
              7.0950000e+002  5.0116079e-001
              7.1000000e+002  4.9796255e-001
              7.1050000e+002  4.9508362e-001
              7.1100000e+002  4.9220470e-001
              7.1150000e+002  4.8932577e-001
              7.1200000e+002  4.8644684e-001
              7.1250000e+002  4.8309329e-001
              7.1300000e+002  4.7973974e-001
              7.1350000e+002  4.7638620e-001
              7.1400000e+002  4.7303265e-001
              7.1450000e+002  4.6986524e-001
              7.1500000e+002  4.6669783e-001
              7.1550000e+002  4.6353042e-001
              7.1600000e+002  4.6036302e-001
              7.1650000e+002  4.5755399e-001
              7.1700000e+002  4.5474496e-001
              7.1750000e+002  4.5193593e-001
              7.1800000e+002  4.4912691e-001
              7.1850000e+002  4.4661044e-001
              7.1900000e+002  4.4409397e-001
              7.1950000e+002  4.4157750e-001
              7.2000000e+002  4.3906103e-001
              7.2050000e+002  4.3703350e-001
              7.2100000e+002  4.3500597e-001
              7.2150000e+002  4.3297844e-001
              7.2200000e+002  4.3095091e-001
              7.2250000e+002  4.2950659e-001
              7.2300000e+002  4.2806227e-001
              7.2350000e+002  4.2661795e-001
              7.2400000e+002  4.2517362e-001
              7.2450000e+002  4.2406847e-001
              7.2500000e+002  4.2296331e-001
              7.2550000e+002  4.2185816e-001
              7.2600000e+002  4.2075300e-001
              7.2650000e+002  4.1981891e-001
              7.2700000e+002  4.1888482e-001
              7.2750000e+002  4.1795073e-001
              7.2800000e+002  4.1701664e-001
              7.2850000e+002  4.1654428e-001
              7.2900000e+002  4.1607191e-001
              7.2950000e+002  4.1559955e-001
              7.3000000e+002  4.1512718e-001
              7.3050000e+002  4.1505277e-001
              7.3100000e+002  4.1497836e-001
              7.3150000e+002  4.1490395e-001
              7.3200000e+002  4.1482954e-001
              7.3250000e+002  4.1477623e-001
              7.3300000e+002  4.1472291e-001
              7.3350000e+002  4.1466960e-001
              7.3400000e+002  4.1461628e-001
              7.3450000e+002  4.1479630e-001
              7.3500000e+002  4.1497632e-001
              7.3550000e+002  4.1515633e-001
              7.3600000e+002  4.1533635e-001
              7.3650000e+002  4.1555474e-001
              7.3700000e+002  4.1577314e-001
              7.3750000e+002  4.1599153e-001
              7.3800000e+002  4.1620993e-001
              7.3850000e+002  4.1670986e-001
              7.3900000e+002  4.1720980e-001
              7.3950000e+002  4.1770974e-001
              7.4000000e+002  4.1820967e-001
              7.4050000e+002  4.1892740e-001
              7.4100000e+002  4.1964513e-001
              7.4150000e+002  4.2036286e-001
              7.4200000e+002  4.2108058e-001
              7.4250000e+002  4.2179731e-001
              7.4300000e+002  4.2251404e-001
              7.4350000e+002  4.2323076e-001
              7.4400000e+002  4.2394749e-001
              7.4450000e+002  4.2453814e-001
              7.4500000e+002  4.2512878e-001
              7.4550000e+002  4.2571943e-001
              7.4600000e+002  4.2631007e-001
              7.4650000e+002  4.2678948e-001
              7.4700000e+002  4.2726889e-001
              7.4750000e+002  4.2774830e-001
              7.4800000e+002  4.2822770e-001
              7.4850000e+002  4.2880242e-001
              7.4900000e+002  4.2937714e-001
              7.4950000e+002  4.2995185e-001
              7.5000000e+002  4.3052657e-001
              7.5050000e+002  4.3148348e-001
              7.5100000e+002  4.3244039e-001
              7.5150000e+002  4.3339730e-001
              7.5200000e+002  4.3435422e-001
              7.5250000e+002  4.3511742e-001
              7.5300000e+002  4.3588062e-001
              7.5350000e+002  4.3664382e-001
              7.5400000e+002  4.3740702e-001
              7.5450000e+002  4.3781744e-001
              7.5500000e+002  4.3822787e-001
              7.5550000e+002  4.3863830e-001
              7.5600000e+002  4.3904872e-001
              7.5650000e+002  4.3940898e-001
              7.5700000e+002  4.3976923e-001
              7.5750000e+002  4.4012949e-001
              7.5800000e+002  4.4048975e-001
              7.5850000e+002  4.4084169e-001
              7.5900000e+002  4.4119364e-001
              7.5950000e+002  4.4154558e-001
              7.6000000e+002  4.4189753e-001
              7.6050000e+002  4.4222139e-001
              7.6100000e+002  4.4254525e-001
              7.6150000e+002  4.4286911e-001
              7.6200000e+002  4.4319298e-001
              7.6250000e+002  4.4377194e-001
              7.6300000e+002  4.4435090e-001
              7.6350000e+002  4.4492986e-001
              7.6400000e+002  4.4550882e-001
              7.6450000e+002  4.4615044e-001
              7.6500000e+002  4.4679205e-001
              7.6550000e+002  4.4743367e-001
              7.6600000e+002  4.4807529e-001
              7.6650000e+002  4.4866327e-001
              7.6700000e+002  4.4925126e-001
              7.6750000e+002  4.4983925e-001
              7.6800000e+002  4.5042724e-001
              7.6850000e+002  4.5104584e-001
              7.6900000e+002  4.5166445e-001
              7.6950000e+002  4.5228305e-001
              7.7000000e+002  4.5290166e-001
              7.7050000e+002  4.5346397e-001
              7.7100000e+002  4.5402629e-001
              7.7150000e+002  4.5458860e-001
              7.7200000e+002  4.5515091e-001
              7.7250000e+002  4.5580540e-001
              7.7300000e+002  4.5645989e-001
              7.7350000e+002  4.5711438e-001
              7.7400000e+002  4.5776888e-001
              7.7450000e+002  4.5874658e-001
              7.7500000e+002  4.5972429e-001
              7.7550000e+002  4.6070200e-001
              7.7600000e+002  4.6167971e-001
              7.7650000e+002  4.6304014e-001
              7.7700000e+002  4.6440057e-001
              7.7750000e+002  4.6576100e-001
              7.7800000e+002  4.6712143e-001
              7.7850000e+002  4.6842946e-001
              7.7900000e+002  4.6973749e-001
              7.7950000e+002  4.7104552e-001
              7.8000000e+002  4.7235355e-001
              7.8050000e+002  4.7364174e-001
              7.8100000e+002  4.7492993e-001
              7.8150000e+002  4.7621812e-001
              7.8200000e+002  4.7750631e-001
              7.8250000e+002  4.7897505e-001
              7.8300000e+002  4.8044380e-001
              7.8350000e+002  4.8191254e-001
              7.8400000e+002  4.8338128e-001
              7.8450000e+002  4.8455794e-001
              7.8500000e+002  4.8573459e-001
              7.8550000e+002  4.8691125e-001
              7.8600000e+002  4.8808791e-001
              7.8650000e+002  4.8910580e-001
              7.8700000e+002  4.9012369e-001
              7.8750000e+002  4.9114158e-001
              7.8800000e+002  4.9215948e-001
              7.8850000e+002  4.9300490e-001
              7.8900000e+002  4.9385033e-001
              7.8950000e+002  4.9469576e-001
              7.9000000e+002  4.9554119e-001
              7.9050000e+002  4.9630072e-001
              7.9100000e+002  4.9706025e-001
              7.9150000e+002  4.9781978e-001
              7.9200000e+002  4.9857931e-001
              7.9250000e+002  5.0001031e-001
              7.9300000e+002  5.0144130e-001
              7.9350000e+002  5.0287230e-001
              7.9400000e+002  5.0430330e-001
              7.9450000e+002  5.0577552e-001
              7.9500000e+002  5.0724773e-001
              7.9550000e+002  5.0871995e-001
              7.9600000e+002  5.1019217e-001
              7.9650000e+002  5.1177102e-001
              7.9700000e+002  5.1334987e-001
              7.9750000e+002  5.1492872e-001
              7.9800000e+002  5.1650758e-001
              7.9850000e+002  5.1767295e-001
              7.9900000e+002  5.1883832e-001
              7.9950000e+002  5.2000370e-001
              8.0000000e+002  5.2116907e-001
              8.0050000e+002  5.2170964e-001
              8.0100000e+002  5.2225020e-001
              8.0150000e+002  5.2279077e-001
              8.0200000e+002  5.2333133e-001
              8.0250000e+002  5.2390635e-001
              8.0300000e+002  5.2448137e-001
              8.0350000e+002  5.2505639e-001
              8.0400000e+002  5.2563141e-001
              8.0450000e+002  5.2629161e-001
              8.0500000e+002  5.2695181e-001
              8.0550000e+002  5.2761202e-001
              8.0600000e+002  5.2827222e-001
              8.0650000e+002  5.2901213e-001
              8.0700000e+002  5.2975205e-001
              8.0750000e+002  5.3049196e-001
              8.0800000e+002  5.3123187e-001
              8.0850000e+002  5.3190100e-001
              8.0900000e+002  5.3257012e-001
              8.0950000e+002  5.3323925e-001
              8.1000000e+002  5.3390837e-001
              8.1050000e+002  5.3437521e-001
              8.1100000e+002  5.3484206e-001
              8.1150000e+002  5.3530890e-001
              8.1200000e+002  5.3577574e-001
              8.1250000e+002  5.3610282e-001
              8.1300000e+002  5.3642990e-001
              8.1350000e+002  5.3675698e-001
              8.1400000e+002  5.3708406e-001
              8.1450000e+002  5.3738179e-001
              8.1500000e+002  5.3767952e-001
              8.1550000e+002  5.3797726e-001
              8.1600000e+002  5.3827499e-001
              8.1650000e+002  5.3858777e-001
              8.1700000e+002  5.3890055e-001
              8.1750000e+002  5.3921333e-001
              8.1800000e+002  5.3952611e-001
              8.1850000e+002  5.3983715e-001
              8.1900000e+002  5.4014818e-001
              8.1950000e+002  5.4045922e-001
              8.2000000e+002  5.4077026e-001
              8.2050000e+002  5.4086522e-001
              8.2100000e+002  5.4096019e-001
              8.2150000e+002  5.4105515e-001
              8.2200000e+002  5.4115011e-001
              8.2250000e+002  5.4097464e-001
              8.2300000e+002  5.4079916e-001
              8.2350000e+002  5.4062369e-001
              8.2400000e+002  5.4044822e-001
              8.2450000e+002  5.4014545e-001
              8.2500000e+002  5.3984269e-001
              8.2550000e+002  5.3953992e-001
              8.2600000e+002  5.3923716e-001
              8.2650000e+002  5.3884421e-001
              8.2700000e+002  5.3845126e-001
              8.2750000e+002  5.3805832e-001
              8.2800000e+002  5.3766537e-001
              8.2850000e+002  5.3726601e-001
              8.2900000e+002  5.3686664e-001
              8.2950000e+002  5.3646728e-001
              8.3000000e+002  5.3606792e-001
              8.3050000e+002  5.3569046e-001
              8.3100000e+002  5.3531300e-001
              8.3150000e+002  5.3493554e-001
              8.3200000e+002  5.3455808e-001
              8.3250000e+002  5.3425944e-001
              8.3300000e+002  5.3396080e-001
              8.3350000e+002  5.3366216e-001
              8.3400000e+002  5.3336352e-001
              8.3450000e+002  5.3316411e-001
              8.3500000e+002  5.3296470e-001
              8.3550000e+002  5.3276529e-001
              8.3600000e+002  5.3256588e-001
              8.3650000e+002  5.3247892e-001
              8.3700000e+002  5.3239197e-001
              8.3750000e+002  5.3230501e-001
              8.3800000e+002  5.3221806e-001
              8.3850000e+002  5.3211789e-001
              8.3900000e+002  5.3201773e-001
              8.3950000e+002  5.3191756e-001
              8.4000000e+002  5.3181739e-001
              8.4050000e+002  5.3159895e-001
              8.4100000e+002  5.3138050e-001
              8.4150000e+002  5.3116205e-001
              8.4200000e+002  5.3094361e-001
              8.4250000e+002  5.3066563e-001
              8.4300000e+002  5.3038766e-001
              8.4350000e+002  5.3010968e-001
              8.4400000e+002  5.2983171e-001
              8.4450000e+002  5.2956491e-001
              8.4500000e+002  5.2929812e-001
              8.4550000e+002  5.2903132e-001
              8.4600000e+002  5.2876453e-001
              8.4650000e+002  5.2859686e-001
              8.4700000e+002  5.2842920e-001
              8.4750000e+002  5.2826153e-001
              8.4800000e+002  5.2809386e-001
              8.4850000e+002  5.2801195e-001
              8.4900000e+002  5.2793003e-001
              8.4950000e+002  5.2784811e-001
              8.5000000e+002  5.2776619e-001
              8.5050000e+002  5.2746834e-001
              8.5100000e+002  5.2717049e-001
              8.5150000e+002  5.2687263e-001
              8.5200000e+002  5.2657478e-001
              8.5250000e+002  5.2601940e-001
              8.5300000e+002  5.2546403e-001
              8.5350000e+002  5.2490865e-001
              8.5400000e+002  5.2435328e-001
              8.5450000e+002  5.2352321e-001
              8.5500000e+002  5.2269315e-001
              8.5550000e+002  5.2186309e-001
              8.5600000e+002  5.2103302e-001
              8.5650000e+002  5.2004711e-001
              8.5700000e+002  5.1906120e-001
              8.5750000e+002  5.1807528e-001
              8.5800000e+002  5.1708937e-001
              8.5850000e+002  5.1629274e-001
              8.5900000e+002  5.1549610e-001
              8.5950000e+002  5.1469947e-001
              8.6000000e+002  5.1390283e-001
              8.6050000e+002  5.1338676e-001
              8.6100000e+002  5.1287070e-001
              8.6150000e+002  5.1235463e-001
              8.6200000e+002  5.1183857e-001
              8.6250000e+002  5.1133847e-001
              8.6300000e+002  5.1083837e-001
              8.6350000e+002  5.1033827e-001
              8.6400000e+002  5.0983817e-001
              8.6450000e+002  5.0916645e-001
              8.6500000e+002  5.0849474e-001
              8.6550000e+002  5.0782302e-001
              8.6600000e+002  5.0715131e-001
              8.6650000e+002  5.0635557e-001
              8.6700000e+002  5.0555984e-001
              8.6750000e+002  5.0476411e-001
              8.6800000e+002  5.0396838e-001
              8.6850000e+002  5.0282658e-001
              8.6900000e+002  5.0168478e-001
              8.6950000e+002  5.0054299e-001
              8.7000000e+002  4.9940119e-001
              8.7050000e+002  4.9772793e-001
              8.7100000e+002  4.9605467e-001
              8.7150000e+002  4.9438141e-001
              8.7200000e+002  4.9270815e-001
              8.7250000e+002  4.9123397e-001
              8.7300000e+002  4.8975980e-001
              8.7350000e+002  4.8828562e-001
              8.7400000e+002  4.8681145e-001
              8.7450000e+002  4.8567142e-001
              8.7500000e+002  4.8453139e-001
              8.7550000e+002  4.8339137e-001
              8.7600000e+002  4.8225134e-001
              8.7650000e+002  4.8129036e-001
              8.7700000e+002  4.8032938e-001
              8.7750000e+002  4.7936841e-001
              8.7800000e+002  4.7840743e-001
              8.7850000e+002  4.7750085e-001
              8.7900000e+002  4.7659428e-001
              8.7950000e+002  4.7568770e-001
              8.8000000e+002  4.7478112e-001
              8.8050000e+002  4.7390575e-001
              8.8100000e+002  4.7303039e-001
              8.8150000e+002  4.7215502e-001
              8.8200000e+002  4.7127965e-001
              8.8250000e+002  4.7019206e-001
              8.8300000e+002  4.6910447e-001
              8.8350000e+002  4.6801688e-001
              8.8400000e+002  4.6692929e-001
              8.8450000e+002  4.6576740e-001
              8.8500000e+002  4.6460552e-001
              8.8550000e+002  4.6344363e-001
              8.8600000e+002  4.6228175e-001
              8.8650000e+002  4.6108543e-001
              8.8700000e+002  4.5988910e-001
              8.8750000e+002  4.5869278e-001
              8.8800000e+002  4.5749646e-001
              8.8850000e+002  4.5599046e-001
              8.8900000e+002  4.5448446e-001
              8.8950000e+002  4.5297846e-001
              8.9000000e+002  4.5147246e-001
              8.9050000e+002  4.5001098e-001
              8.9100000e+002  4.4854950e-001
              8.9150000e+002  4.4708802e-001
              8.9200000e+002  4.4562653e-001
              8.9250000e+002  4.4404932e-001
              8.9300000e+002  4.4247210e-001
              8.9350000e+002  4.4089488e-001
              8.9400000e+002  4.3931766e-001
              8.9450000e+002  4.3759003e-001
              8.9500000e+002  4.3586239e-001
              8.9550000e+002  4.3413476e-001
              8.9600000e+002  4.3240713e-001
              8.9650000e+002  4.3071228e-001
              8.9700000e+002  4.2901743e-001
              8.9750000e+002  4.2732258e-001
              8.9800000e+002  4.2562773e-001
              8.9850000e+002  4.2413598e-001
              8.9900000e+002  4.2264422e-001
              8.9950000e+002  4.2115247e-001
              9.0000000e+002  4.1966072e-001
              9.0050000e+002  4.1850323e-001
              9.0100000e+002  4.1734574e-001
              9.0150000e+002  4.1618825e-001
              9.0200000e+002  4.1503076e-001
              9.0250000e+002  4.1411717e-001
              9.0300000e+002  4.1320358e-001
              9.0350000e+002  4.1228999e-001
              9.0400000e+002  4.1137640e-001
              9.0450000e+002  4.1056765e-001
              9.0500000e+002  4.0975889e-001
              9.0550000e+002  4.0895014e-001
              9.0600000e+002  4.0814138e-001
              9.0650000e+002  4.0740348e-001
              9.0700000e+002  4.0666558e-001
              9.0750000e+002  4.0592768e-001
              9.0800000e+002  4.0518978e-001
              9.0850000e+002  4.0446823e-001
              9.0900000e+002  4.0374669e-001
              9.0950000e+002  4.0302514e-001
              9.1000000e+002  4.0230360e-001
              9.1050000e+002  4.0118053e-001
              9.1100000e+002  4.0005746e-001
              9.1150000e+002  3.9893439e-001
              9.1200000e+002  3.9781132e-001
              9.1250000e+002  3.9667644e-001
              9.1300000e+002  3.9554156e-001
              9.1350000e+002  3.9440668e-001
              9.1400000e+002  3.9327180e-001
              9.1450000e+002  3.9214808e-001
              9.1500000e+002  3.9102437e-001
              9.1550000e+002  3.8990065e-001
              9.1600000e+002  3.8877694e-001
              9.1650000e+002  3.8718648e-001
              9.1700000e+002  3.8559602e-001
              9.1750000e+002  3.8400556e-001
              9.1800000e+002  3.8241511e-001
              9.1850000e+002  3.8079458e-001
              9.1900000e+002  3.7917406e-001
              9.1950000e+002  3.7755354e-001
              9.2000000e+002  3.7593302e-001
              9.2050000e+002  3.7428388e-001
              9.2100000e+002  3.7263474e-001
              9.2150000e+002  3.7098560e-001
              9.2200000e+002  3.6933647e-001
              9.2250000e+002  3.6742515e-001
              9.2300000e+002  3.6551383e-001
              9.2350000e+002  3.6360251e-001
              9.2400000e+002  3.6169119e-001
              9.2450000e+002  3.5935763e-001
              9.2500000e+002  3.5702408e-001
              9.2550000e+002  3.5469052e-001
              9.2600000e+002  3.5235696e-001
              9.2650000e+002  3.5020949e-001
              9.2700000e+002  3.4806201e-001
              9.2750000e+002  3.4591454e-001
              9.2800000e+002  3.4376706e-001
              9.2850000e+002  3.4207196e-001
              9.2900000e+002  3.4037685e-001
              9.2950000e+002  3.3868174e-001
              9.3000000e+002  3.3698664e-001
              9.3050000e+002  3.3531468e-001
              9.3100000e+002  3.3364273e-001
              9.3150000e+002  3.3197077e-001
              9.3200000e+002  3.3029882e-001
              9.3250000e+002  3.2829975e-001
              9.3300000e+002  3.2630069e-001
              9.3350000e+002  3.2430162e-001
              9.3400000e+002  3.2230256e-001
              9.3450000e+002  3.2014129e-001
              9.3500000e+002  3.1798002e-001
              9.3550000e+002  3.1581875e-001
              9.3600000e+002  3.1365747e-001
              9.3650000e+002  3.1151386e-001
              9.3700000e+002  3.0937026e-001
              9.3750000e+002  3.0722665e-001
              9.3800000e+002  3.0508304e-001
              9.3850000e+002  3.0292138e-001
              9.3900000e+002  3.0075971e-001
              9.3950000e+002  2.9859805e-001
              9.4000000e+002  2.9643639e-001
              9.4050000e+002  2.9481181e-001
              9.4100000e+002  2.9318724e-001
              9.4150000e+002  2.9156266e-001
              9.4200000e+002  2.8993809e-001
              9.4250000e+002  2.8864886e-001
              9.4300000e+002  2.8735962e-001
              9.4350000e+002  2.8607039e-001
              9.4400000e+002  2.8478116e-001
              9.4450000e+002  2.8361146e-001
              9.4500000e+002  2.8244176e-001
              9.4550000e+002  2.8127206e-001
              9.4600000e+002  2.8010236e-001
              9.4650000e+002  2.7845904e-001
              9.4700000e+002  2.7681573e-001
              9.4750000e+002  2.7517241e-001
              9.4800000e+002  2.7352909e-001
              9.4850000e+002  2.7153475e-001
              9.4900000e+002  2.6954041e-001
              9.4950000e+002  2.6754607e-001
              9.5000000e+002  2.6555173e-001];

% 2.303 converts extin to mua; 1e-7 converts from 1/(cm*M) to 1/(mm*uM)
chrome.hb(:, 2:3) = chrome.hb(:, [3 2]) * 2.303 * 1e-7;
chrome.hbo = chrome.hb(:, [1 3]);
chrome.hbr = chrome.hb(:, [1 2]);

chrome.water(:, 2) = chrome.water(:, 2) .* 0.1;
chrome.lipids(:, 2) = chrome.lipids(:, 2);

if (iscell(wavelen) && ~isempty(wavelen))
    if (isempty(wavelen{1}))
        error('you must provide non-empty wavelength list');
    end
    wavelen = cellfun(@str2double, wavelen);
end

if (ischar(type))
    extin = zeros(length(wavelen), 1);
    spectrum = chrome.(lower(type));
    for i = 1:length(wavelen)
        extin(i) = interp1(spectrum(:, 1), spectrum(:, 2), wavelen(i), varargin{:});
    end
elseif (iscell(type))
    extin = zeros(length(wavelen), length(type));
    for i = 1:length(wavelen)
        for j = 1:length(type)
            spectrum = chrome.(lower(type{j}));
            extin(i, j) = interp1(spectrum(:, 1), spectrum(:, 2), wavelen(i), varargin{:});
        end
    end
else
    error('type must be a string or a cell');
end
