%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MCXLAB - Monte Carlo eXtreme for MATLAB/Octave by Qianqina Fang
%
% In this example, we show how to set the 7-12 elements of cfg.bc to
% indicate a planar detector along a boundary facet
%
% This file is part of Monte Carlo eXtreme (MCX) URL:https://mcx.space
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% only clear cfg to avoid accidentally clearing other useful data
clear cfg cfgs;
cfg.nphoton = 1e5;
cfg.vol = uint8(ones(60, 60, 60));
cfg.srcpos = [30 30 1];
cfg.srcdir = [0 0 1];
cfg.gpuid = 1;
% cfg.gpuid='11'; % use two GPUs together
cfg.autopilot = 1;
cfg.prop = [0 0 1 1; 0.005 1 0 1.37];
cfg.tstart = 0;
cfg.tend = 5e-9;
cfg.tstep = 1e-10;

% calculate the flux distribution with the given config
cfg.bc = '______111110';  % capture photons existing from all faces except z=z_max
cfg.savedetflag = 'dpx';

[flux, detpt] = mcxlab(cfg);
plot3(detpt.p(:, 1), detpt.p(:, 2), detpt.p(:, 3), 'r.');
view([0 0 -1]);
