%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MMCLAB - Mesh-based Monte Carlo for MATLAB/Octave by Qianqina Fang
%
% In this example, we show the most basic usage of MMCLAB.
%
% This file is part of Mesh-based Monte Carlo (MMC) URL:https://mcx.space/mmc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% prepare simulation input

clear cfg;
cfg.nphoton = 1e6;
[cfg.node, face, cfg.elem] = meshabox([0 0 0], [60 60 30], 6);
cfg.elemprop = ones(size(cfg.elem, 1), 1);
cfg.srcpos = [30 30 0];
cfg.srcdir = [0 0 1];
cfg.prop = [0 0 1 1; 0.005 1 0 1.37];
cfg.tstart = 0;
cfg.tend = 5e-9;
cfg.tstep = 5e-9;
cfg.debuglevel = 'TP';
cfg.issaveref = 1;  % in addition to volumetric fluence, also save surface diffuse reflectance
cfg.method = 'elem';

%% run the simulation

flux = mmclab(cfg);

%% plotting the result

% plot the cross-section of the fluence
subplot(121);
plotmesh([cfg.node(:, 1:3), log10(abs(flux.data(1:size(cfg.node, 1))))], cfg.elem, 'y=30', 'facecolor', 'interp', 'linestyle', 'none');
view([0 1 0]);
colorbar;

% plot the surface diffuse reflectance
if (isfield(cfg, 'issaveref') && cfg.issaveref == 1)
    subplot(122);
    faces = faceneighbors(cfg.elem, 'rowmajor');
    hs = plotmesh(cfg.node, faces, 'cdata', log10(flux.dref(:, 1)), 'linestyle', 'none');
    colorbar;
end
